package ontologias.frutasOntology;

import jade.content.AgentAction;
import jade.content.lang.Codec.CodecException;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.OntologyException;
import jade.core.Agent;
import jade.lang.acl.ACLMessage;

public class Comprar implements AgentAction {
 
   private Fruta fruta;
   
   //Aadido los atributos necesarios para realizar las acciones de envo de mensajes
   private Agent agente;
   private ACLMessage msg;
   
   //Aadido constructor por defecto para agregar la fruta 

   public Comprar(Fruta f){ 
	   fruta=f;	   
	   agente=f.getAgente();
	   msg=f.getMensaje();
   } 
   
   public Fruta getFruta() {
     return fruta;
   }
 
   public void setFruta(Fruta f) {
     fruta = f;
   }
   
   //Mtodos de respuesta a una oferta
   public void aceptar() throws CodecException, OntologyException {
	   ACLMessage msg2 = new ACLMessage(ACLMessage.REQUEST);
       msg2.setLanguage(new SLCodec().getName());
       msg2.setOntology(frutasOntology.getInstance().getName());
       msg2.setSender(agente.getAID());
       msg2.addReceiver(msg.getSender());
       agente.getContentManager().fillContent(msg2,this);
       agente.send(msg2);
       System.out.println("AC: Accin de Compra solicitada.");
   }
   
   public void rechazar() throws CodecException, OntologyException {
	   ACLMessage msg2 = new ACLMessage(ACLMessage.DISCONFIRM);
       msg2.setLanguage(new SLCodec().getName());
       msg2.setOntology(frutasOntology.getInstance().getName());
       msg2.setSender(agente.getAID());
       msg2.addReceiver(msg.getSender());
       agente.getContentManager().fillContent(msg2,this);
       agente.send(msg2);
       System.out.println("AC: Accin de Compra rechazada.");
   }
   
   public void negociar() throws CodecException, OntologyException {
	   ACLMessage msg2 = new ACLMessage(ACLMessage.PROPOSE);
       msg2.setLanguage(new SLCodec().getName());
       msg2.setOntology(frutasOntology.getInstance().getName());
       msg2.setSender(agente.getAID());
       msg2.addReceiver(msg.getSender());
       //Creamos predicado "Oferta" para comunicar la oferta realizada (el concepto FRUTA)
       Oferta of = new Oferta();
       of.setFruta(fruta);
       agente.getContentManager().fillContent(msg2,of);
       agente.send(msg2);
       System.out.println("AC: Demasiado caro, me lo puedes poner ms barato?.");
   }
   
   public void variarPrecio() throws CodecException, OntologyException {
	   ACLMessage msg2 = new ACLMessage(ACLMessage.INFORM);
       msg2.setLanguage(new SLCodec().getName());
       msg2.setOntology(frutasOntology.getInstance().getName());
       msg2.setSender(agente.getAID());
       msg2.addReceiver(msg.getSender());
       
    // Quiere negociar.
       int cantidad=1;
       if(fruta.getHumorComprador()=="buenas") cantidad=-1;
	   fruta.setPrecio(fruta.getPrecio()+cantidad);
	   Oferta of2 = new Oferta();
	   of2.setFruta(fruta);
       agente.getContentManager().fillContent(msg2,of2);
       agente.send(msg2);
       System.out.println("AV: Espero que le guste la nueva oferta.");
   }
   
}


